<?php
include "../public/menu.php";
include '../db/conexion.php';

// Sanitize input to prevent SQL injection
$doi = isset($_GET["doi"]) ? mysqli_real_escape_string($conn, trim($_GET["doi"])) : '';

// Prepare the query using parameterized statements
if (!empty($doi)) {
    $stmt = $conn->prepare("SELECT * FROM exp_data WHERE doi = ? OR apellido1 = ?");
    $stmt->bind_param("ss", $doi, $doi);
} else {
    $stmt = $conn->prepare("SELECT * FROM exp_data ORDER BY id DESC");
}

$stmt->execute();
$result = $stmt->get_result();

// Función para formatear la fecha al estilo español
function formatearFecha($fecha) {
    $timestamp = strtotime($fecha);
    return date('d/m/Y', $timestamp);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Expedientes de Canjes - SWAP</title>
    <style>
        :root {
            --primary-color: #0d6efd;
            --border-color: #dee2e6;
            --hover-color: #f8f9fa;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .table-responsive {
            margin-top: 20px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        
        .search-container {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border: 1px solid var(--border-color);
        }
        
        .page-header {
            background-color: white;
            padding: 20px 0;
            margin-bottom: 30px;
            border-bottom: 1px solid var(--border-color);
        }
        
        .page-header h2 {
            color: #212529;
            font-weight: 500;
        }
        
        .table {
            margin-bottom: 0;
        }
        
        .table th {
            background-color: #f8f9fa;
            border-bottom: 2px solid var(--border-color);
            color: #495057;
            font-weight: 600;
            padding: 12px;
        }
        
        .table td {
            padding: 12px;
            vertical-align: middle;
        }
        
        .table tbody tr:hover {
            background-color: var(--hover-color);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border: none;
            padding: 8px 20px;
        }
        
        .fecha-column {
            min-width: 180px;
        }
        
        .empty-message {
            padding: 20px;
            color: #6c757d;
        }
        
        .form-control:focus {
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <!-- Page Header -->
        <div class="page-header">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col">
                        <h2 class="mb-0">Expedientes de Canjes</h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search Section -->
        <div class="container">
            <div class="search-container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <form method="GET" class="d-flex justify-content-center gap-2">
                            <div class="input-group">
                                <input 
                                    class="form-control" 
                                    name="doi" 
                                    type="search" 
                                    placeholder="Buscar por DOI o 1r APELLIDO" 
                                    aria-label="Search"
                                    value="<?= htmlspecialchars($doi) ?>"
                                >
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-search"></i> Buscar
                                </button>
                            </div>
                        </form>
                        <div class="text-center mt-4">
                            <?php include "new-exp.php"; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Table Section -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th scope="col">DOI</th>
                            <th scope="col">NOMBRE</th>
                            <th scope="col">APELLIDOS</th>
                            <th scope="col">PAÍS DE NACIMIENTO</th>
                            <th scope="col" class="fecha-column">FECHA INICIO</th>
                            <th scope="col" class="text-center">ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result->num_rows > 0): ?>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row["doi"]) ?></td>
                                    <td><?= htmlspecialchars($row["nombre"]) ?></td>
                                    <td><?= htmlspecialchars($row["apellido1"]) ?> <?= htmlspecialchars($row["apellido2"]) ?></td>
                                    <td><?= htmlspecialchars($row["P_NACIMIENTO"]) ?></td>
                                    <td class="fecha-column"><?= formatearFecha($row["FECHA_CREACION"]) ?></td>
                                    <td class="text-center">
                                        <a href='../exp/index.php?doi=<?= urlencode($row["doi"]) ?>' 
                                           class='btn btn-primary btn-sm'>
                                            <i class="fas fa-edit"></i> Gestionar
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan='6' class="text-center empty-message">No se encontraron resultados</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

 

    <?php 
    $stmt->close();
    $conn->close(); 
    ?>
</body>
</html>