<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Expedientes de Canjes - SWAP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .modal-header { border-radius: 0.375rem 0.375rem 0 0; }
        .card { border: 1px solid rgba(0,0,0,.125); box-shadow: 0 1px 3px rgba(0,0,0,.1); }
        .card-header { background-color: #f8f9fa; border-bottom: 1px solid rgba(0,0,0,.125); }
        .form-label { font-weight: 500; color: #212529; }
        .btn { font-weight: 500; }
        .modal-content { border: none; box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); }
    </style>
</head>
<body>
<div class="container mt-5">
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#formModal">
        <i class="fas fa-plus-circle me-2"></i>Alta Nuevo Expediente
    </button>

    <div class="modal fade" id="formModal" tabindex="-1" aria-labelledby="formModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="formModalLabel"><i class="fas fa-file-alt me-2"></i>Nuevo Expediente</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
						<form id="expedienteForm" method="post" action="../tram/nwexp/insertar_datos.php" class="needs-validation" novalidate>
                        <div class="card mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">Datos Personales</h6>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">DNI/NIE</label>
                                        <input type="text" class="form-control" name="doi" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Nombre</label>
                                        <input type="text" class="form-control" name="nombre" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Primer Apellido</label>
                                        <input type="text" class="form-control" name="apellido1" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Segundo Apellido</label>
                                        <input type="text" class="form-control" name="apellido2" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Fecha de Nacimiento</label>
                                        <input type="date" class="form-control" name="fecha_nacimiento" required>
                                    </div>
                                    <h4 class="section-title">Dirección 1 (Formato INE)</h4>
    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">Tipo de vía</label>
        <input type="text" class="form-control" name="tipo_via1" required />
      </div>
      <div class="col-md-6">
        <label class="form-label">Nombre de la vía</label>
        <input type="text" class="form-control" name="nombre_via1" required />
      </div>
      <div class="col-md-3">
        <label class="form-label">Número</label>
        <input type="text" class="form-control" name="numero1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Bloque</label>
        <input type="text" class="form-control" name="bloque1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Portal</label>
        <input type="text" class="form-control" name="portal1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Escalera</label>
        <input type="text" class="form-control" name="escalera1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Planta</label>
        <input type="text" class="form-control" name="planta1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Puerta</label>
        <input type="text" class="form-control" name="puerta1" />
      </div>
      <div class="col-md-2">
        <label class="form-label">KM</label>
        <input type="text" class="form-control" name="km1" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Código Postal</label>
        <input type="text" class="form-control" name="cp1" required />
      </div>
      <div class="col-md-3">
        <label class="form-label" for="provincia1">Provincia</label>
<select class="form-control" name="provincia1" id="provincia1" required>
  <option value="">Seleccione una provincia</option>
  <option value="Álava">Álava</option>
  <option value="Albacete">Albacete</option>
  <option value="Alicante">Alicante</option>
  <option value="Almería">Almería</option>
  <option value="Asturias">Asturias</option>
  <option value="Ávila">Ávila</option>
  <option value="Badajoz">Badajoz</option>
  <option value="Barcelona">Barcelona</option>
  <option value="Burgos">Burgos</option>
  <option value="Cáceres">Cáceres</option>
  <option value="Cádiz">Cádiz</option>
  <option value="Cantabria">Cantabria</option>
  <option value="Castellón">Castellón</option>
  <option value="Ciudad Real">Ciudad Real</option>
  <option value="Córdoba">Córdoba</option>
  <option value="Cuenca">Cuenca</option>
  <option value="Gerona">Gerona</option>
  <option value="Granada">Granada</option>
  <option value="Guadalajara">Guadalajara</option>
  <option value="Guipúzcoa">Guipúzcoa</option>
  <option value="Huelva">Huelva</option>
  <option value="Huesca">Huesca</option>
  <option value="Islas Baleares">Islas Baleares</option>
  <option value="Jaén">Jaén</option>
  <option value="La Coruña">La Coruña</option>
  <option value="La Rioja">La Rioja</option>
  <option value="Las Palmas">Las Palmas</option>
  <option value="León">León</option>
  <option value="Lérida">Lérida</option>
  <option value="Lugo">Lugo</option>
  <option value="Madrid">Madrid</option>
  <option value="Málaga">Málaga</option>
  <option value="Murcia">Murcia</option>
  <option value="Navarra">Navarra</option>
  <option value="Orense">Orense</option>
  <option value="Palencia">Palencia</option>
  <option value="Pontevedra">Pontevedra</option>
  <option value="Salamanca">Salamanca</option>
  <option value="Santa Cruz de Tenerife">Santa Cruz de Tenerife</option>
  <option value="Segovia">Segovia</option>
  <option value="Sevilla">Sevilla</option>
  <option value="Soria">Soria</option>
  <option value="Tarragona">Tarragona</option>
  <option value="Teruel">Teruel</option>
  <option value="Toledo">Toledo</option>
  <option value="Valencia">Valencia</option>
  <option value="Valladolid">Valladolid</option>
  <option value="Vizcaya">Vizcaya</option>
  <option value="Zamora">Zamora</option>
  <option value="Zaragoza">Zaragoza</option>
</select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Municipio</label>
        <input type="text" class="form-control" name="municipio1" required />
      </div>
      <div class="col-md-3">
        <label class="form-label">Localidad</label>
        <input type="text" class="form-control" name="localidad1" required />
      </div>
    </div>

    <h4 class="section-title">Dirección 2 (Formato INE)</h4>
    <div class="row g-2">
      <!-- Misma estructura que dirección 1 -->
      <div class="col-md-3">
        <label class="form-label">Tipo de vía</label>
        <input type="text" class="form-control" name="tipo_via2" />
      </div>
      <div class="col-md-6">
        <label class="form-label">Nombre de la vía</label>
        <input type="text" class="form-control" name="nombre_via2" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Número</label>
        <input type="text" class="form-control" name="numero2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Bloque</label>
        <input type="text" class="form-control" name="bloque2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Portal</label>
        <input type="text" class="form-control" name="portal2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Escalera</label>
        <input type="text" class="form-control" name="escalera2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Planta</label>
        <input type="text" class="form-control" name="planta2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Puerta</label>
        <input type="text" class="form-control" name="puerta2" />
      </div>
      <div class="col-md-2">
        <label class="form-label">KM</label>
        <input type="text" class="form-control" name="km2" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Código Postal</label>
        <input type="text" class="form-control" name="cp2" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Provincia</label>
        <input type="text" class="form-control" name="provincia2" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Municipio</label>
        <input type="text" class="form-control" name="municipio2" />
      </div>
      <div class="col-md-3">
        <label class="form-label">Localidad</label>
        <input type="text" class="form-control" name="localidad2" />
      </div>
    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Teléfono</label>
                                        <input type="tel" class="form-control" name="telefono" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email</label>
                                        <input type="email" class="form-control" name="email">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light"><h6 class="mb-0">Datos del Permiso</h6></div>
                            <div class="card-body">
                                <label class="form-label">¿Grupo 1?</label><br>
                                <input type="radio" name="grupo1" value="si" id="grupo1_si"> <label for="grupo1_si">Sí</label>
                                <input type="radio" name="grupo1" value="no" id="grupo1_no" class="ms-3"> <label for="grupo1_no">No</label>
                                <div id="grupo1_detalles" style="display:none;">
                                    <label class="form-label mt-3">Fecha de Vigencia</label>
                                    <input type="date" class="form-control" name="vigencia_grupo1">
                                    <label class="form-label mt-3">Clases:</label><br>
                                    <input type="checkbox" name="clases_grupo1[]" value="AM"> AM
                                    <input type="checkbox" name="clases_grupo1[]" value="A1"> A1
                                    <input type="checkbox" name="clases_grupo1[]" value="A2"> A2
                                    <input type="checkbox" name="clases_grupo1[]" value="A"> A
                                    <input type="checkbox" name="clases_grupo1[]" value="B"> B
                                    <input type="checkbox" name="clases_grupo1[]" value="B+E"> B+E
                                </div>
                                <hr>
                                <label class="form-label">¿Grupo 2?</label><br>
                                <input type="radio" name="grupo2" value="si" id="grupo2_si"> <label for="grupo2_si">Sí</label>
                                <input type="radio" name="grupo2" value="no" id="grupo2_no" class="ms-3"> <label for="grupo2_no">No</label>
                                <div id="grupo2_detalles" style="display:none;">
                                    <label class="form-label mt-3">Fecha de Vigencia</label>
                                    <input type="date" class="form-control" name="vigencia_grupo2">
                                    <label class="form-label mt-3">Clases:</label><br>
                                    <input type="checkbox" name="clases_grupo2[]" value="C1"> C1
                                    <input type="checkbox" name="clases_grupo2[]" value="C"> C
                                    <input type="checkbox" name="clases_grupo2[]" value="D"> D
                                    <input type="checkbox" name="clases_grupo2[]" value="C1E"> C1E
                                    <input type="checkbox" name="clases_grupo2[]" value="CE"> CE
                                    <input type="checkbox" name="clases_grupo2[]" value="D1E"> D1E
                                    <input type="checkbox" name="clases_grupo2[]" value="DE"> DE
                                    <br><label class="form-label mt-3">¿ADR?</label>
                                    <input type="radio" name="adr" value="si" id="adr_si"> <label for="adr_si">Sí</label>
                                    <input type="radio" name="adr" value="no" id="adr_no" class="ms-3"> <label for="adr_no">No</label>
                                    <div id="adr_fecha" style="display: none;">
                                        <label class="form-label mt-3">Fecha Fin ADR</label>
                                        <input type="date" class="form-control" name="fecha_adr">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light"><h6 class="mb-0">Motivo de Inicio</h6></div>
                            <div class="card-body">
                                <label class="form-label">Motivo</label>
                                <select class="form-select" name="motivo_inicio" id="motivo_inicio" required>
                                    <option value="">Seleccionar</option>
                                    <option value="policia">Policía</option>
                                    <option value="seguridad_social">Seguridad Social</option>
                                    <option value="otros">Otros</option>
                                </select>
                                <div id="detalle_policia" class="mt-3" style="display: none;">
                                    <label class="form-label">Listado Policía</label>
                                    <input type="text" class="form-control" name="motivo_texto">
                                </div>
                                <div id="otros_motivo" class="mt-3" style="display: none;">
                                    <label class="form-label">Especificar motivo</label>
                                    <input type="text" class="form-control" name="motivo_texto">
                                </div>
                            </div>
                        </div>

                        <div class="text-end">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Guardar Expediente</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        function toggleGrupo1() {
            document.getElementById('grupo1_detalles').style.display = document.getElementById('grupo1_si').checked ? 'block' : 'none';
        }
        function toggleGrupo2() {
            document.getElementById('grupo2_detalles').style.display = document.getElementById('grupo2_si').checked ? 'block' : 'none';
        }
        function toggleADR() {
            document.getElementById('adr_fecha').style.display = document.getElementById('adr_si').checked ? 'block' : 'none';
        }
        function toggleMotivo() {
            const motivo = document.getElementById('motivo_inicio').value;
            document.getElementById('detalle_policia').style.display = motivo === 'policia' ? 'block' : 'none';
            document.getElementById('otros_motivo').style.display = motivo === 'otros' ? 'block' : 'none';
        }
        document.getElementById('grupo1_si').addEventListener('change', toggleGrupo1);
        document.getElementById('grupo1_no').addEventListener('change', toggleGrupo1);
        document.getElementById('grupo2_si').addEventListener('change', toggleGrupo2);
        document.getElementById('grupo2_no').addEventListener('change', toggleGrupo2);
        document.getElementById('adr_si').addEventListener('change', toggleADR);
        document.getElementById('adr_no').addEventListener('change', toggleADR);
        document.getElementById('motivo_inicio').addEventListener('change', toggleMotivo);
        toggleGrupo1(); toggleGrupo2(); toggleADR(); toggleMotivo();
    });
</script>
</body>
</html>
