<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de Gestión Documental para Oficio">
    <title>SGDO</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #34495e;
        }
        
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .main-title {
            color: var(--primary-color);
            border-bottom: 3px solid var(--primary-color);
            display: inline-block;
            padding-bottom: 0.5rem;
        }
        
        .card {
            border: none;
            transition: transform 0.2s;
            margin-bottom: 2rem;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background-color: var(--primary-color);
            border-bottom: none;
            border-radius: 8px 8px 0 0 !important;
        }
        
        .btn-custom {
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 6px;
            transition: all 0.3s;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 1rem;
            width: 100%;
        }
        
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        .countries-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            padding: 1rem;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark" style="background-color: var(--primary-color);">
        <div class="container">
            <a class="navbar-brand" href="#">
                ESTD - SWAP CANJES
            </a>
        </div>
    </nav>

    <div class="container mt-5">
        <div class="text-center mb-5">
            <h1 class="main-title display-5 fw-bold">Estadistíca de Canjes</h1>
            <p class="text-muted mt-3">Sistema de Estadistica de Canjes</p>
        </div>

        <div class="countries-grid">
            <div class="card shadow-lg">
                <div class="card-header py-3">
                    <h3 class="text-white mb-0 text-center fw-bold">CANJES TRAMITADOS</h3>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="estd-total.php" class="btn btn-custom btn-primary">TOTAL</a>
                        <a href="estd-gestora.php" class="btn btn-custom btn-success">CANJES DE GESTORIA</a>
                        <a href="estd-ventanilla.php" class="btn btn-custom btn-danger">CANJES DE VENTANILLA</a>
                    </div>
                </div>
            </div>


            <!-- El resto de países seguiría el mismo patrón... -->

        </div>
    </div>

    <footer class="mt-5 py-3 text-center text-muted">
        <small>© 2025 SWAP CANJES. Todos los derechos reservados.</small>
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/js/all.min.js"></script>
</body>
</html>