<?php
// Conexión a la base de datos
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
if ($conn->connect_error) {
    die("Error de conexión: " . htmlspecialchars($conn->connect_error));
}

// Validar y sanitizar el DOI
if (!isset($doi)) {
    die("El DOI no está definido.");
}
$doi = $conn->real_escape_string($doi);

// Consulta SQL con prepared statements
$sql = "SELECT * FROM reg_tram WHERE DOI = ? ORDER BY fecha ASC";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Error en la preparación de la consulta: " . htmlspecialchars($conn->error));
}

$stmt->bind_param("s", $doi);
$stmt->execute();
$result = $stmt->get_result();
?>

<table class="table table-striped">
    <thead>
        <tr>
            <th>Fecha</th>
            <th>Tipo de trámite</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): 
                // Formatear fecha y sanitizar datos
                $fecha = htmlspecialchars(date("d/m/Y", strtotime($row["fecha"])));
                $tramite = htmlspecialchars($row["tramite"]);
                $id = htmlspecialchars($row["id"]);
            ?>
                <tr>
                    <td><?= $fecha ?></td>
                    <td><?= $tramite ?></td>
                    <td>
                        <!-- Botón para eliminar -->
                        <button class="btn btn-danger" onclick="if(confirm('¿Seguro que deseas eliminar este trámite?')) window.location.href='../tram/tramrel/del.php?id=<?= $id ?>&doi=<?= urlencode($doi) ?>';">
                            Eliminar
                        </button>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <!-- Mensaje cuando no hay trámites -->
            <tr>
                <td colspan="3" class="text-center">No se encuentra registrado ningún trámite</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<!-- Botón para añadir trámite -->
<button class="btn btn-primary" onclick="window.location.href='../tram/tramrel/tram.php?doi=<?= urlencode($doi) ?>';">
    Añadir Trámite
</button>

<br><br>

<?php
// Liberar recursos y cerrar conexión
$stmt->close();
$conn->close();
?>
