<?php
include '../../public/menu.php';
include 'crud.php';

// Mostrar la lista de registros
$registros = obtenerRegistros();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="../../assets/css/bootstrap.min.css" rel="stylesheet">
    <title>SWAP - CANJES JPT</title>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center">GESTOR DE FIRMAS OFICIALES</h2>

        <!-- Mostrar la tabla de registros -->
        <table class="table table-bordered mt-3">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>NOMBRE</th>
                    <th>CARGO</th>
                    <th>CARGO EN CATALÁN</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($registros as $registro): ?>
                    <tr>
                        <td><?= $registro['id'] ?></td>
                        <td><?= $registro['NOMBRE'] ?></td>
                        <td><?= $registro['CARGO'] ?></td>
                        <td><?= $registro['CARGO_CAT'] ?></td>
                        <td>
                            <a href="editar.php?id=<?= $registro['id'] ?>" class="btn btn-warning btn-sm">Editar</a>
                            <a href="eliminar.php?id=<?= $registro['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro?')">Eliminar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <!-- Enlace para agregar nuevo registro -->
        <a href="agregar.php" class="btn btn-primary">Agregar nuevo registro</a>
        <a href="../" class="btn btn-secondary">Volver a la lista</a>
    </div>
 

    <!-- Scripts de Bootstrap y jQuery -->
    <script src="../../assets/js/jquery.min.js"></script>
    <script src="../../assets/js/bootstrap.min.js"></script>
</body>
</html>
