<?php
// Activar la captura de salida para evitar errores de encabezado
ob_start();


// Configuración para mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuración de conexión a la base de datos
$host = "localhost";
$dbname = "cnjs_jptgi";
$username = "supervisor";
$password = "Pinpad2021";

// Conectar a la base de datos
$conn = new mysqli($host, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Consulta SQL
$sql = "SELECT * FROM reg_oficios LIMIT 1";
$result = $conn->query($sql);

if (!$result || $result->num_rows == 0) {
    die("No se encontraron resultados.");
}

$row = $result->fetch_assoc();
$nombre = $row['nombre'] ?? '';
$gestoria = $row['gestoria'] ?? '';
$direccion_municipio = $row['direccion_municipio'] ?? '';
$provincia = $row['provincia'] ?? '';
$numero_permiso = $row['numero_permiso'] ?? '';
$categoria = $row['categoria'] ?? '';
$pais = $row['pais'] ?? '';
$doi = $row['doi'] ?? '';
$municipio = $row['municipio'] ?? '';
$codigo_postal = $row['codigo_postal'] ?? '';
$titulo = $row['titulo'] ?? '';
$funcionario = $row['funcionario'] ?? '';
$nref = $row['nref'] ?? '';

$conn->close();

require_once('../FPDF/fpdf.php');
require_once('../FPDI/src/autoload.php');

use setasign\Fpdi\Fpdi;

$pdf = new Fpdi();


// Crear una nueva página
$pdf->AddPage();

// Establecer la imagen de fondo
$imageFile = 'oficio-notificacion.jpg'; // Cambia esto por la ruta de tu imagen
$pdf->Image($imageFile, 0, 0, $pdf->GetPageWidth(), $pdf->GetPageHeight());

// Agregar contenido al PDF
$pdf->SetFont('Arial', '', 10);
$pdf->SetTextColor(0, 0, 0); // Color del texto
$pdf->SetXY(26, 10);
$pdf->Cell(0, 94, "CANJES-$nref", 0, 1);
$pdf->SetXY(26, 10);
$pdf->Cell(0, 123, "Denegando solicitud de canje", 0, 'J');
$pdf->SetXY(14, 10);
$pdf->Cell(0, 132, "GESTORIA $gestoria", 0, 'J');
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetTextColor(0, 51, 0); // Color del texto
$pdf->SetXY(107, 10);
$pdf->Cell(0, 100, "GESTORIA $gestoria", 0, "J");
$pdf->SetXY(107, 10);
$pdf->Cell(0, 109, "$nombre", 0, "J");
$pdf->SetXY(107, 10);
$pdf->Cell(0, 118, "$direccion_municipio", 0, "J");
$pdf->SetXY(107, 10);
$pdf->Cell(0, 127, "$municipio $codigo_postal, $provincia", 0, "J");

// Agregar contenido al PDF
$pdf->SetFont('Arial', '', 10);
$pdf->SetTextColor(0, 0, 0); // Color del texto
$pdf->SetXY(10, 10);

// Texto centrado con MultiCell
$text = "Adjunto se remite resolución denegando la solicitud de canje de permiso núm. $numero_permiso de la categoría $categoria, expedido por $pais, por el equivalente español solicitada por $nombre, con $doi, al efecto de que sea notificada a la GESTORIA $gestoria , la cual ha presentado dicho expediente en la Jefatura Provincial de Tráfico de Girona, actuando en nombre y representación de su cliente. \n \n     Se remite el permiso de conducir original a los efectos de su entrega $nombre \n \n    Se ruega se remita a la Jefatura la copia de la resolución firmada, identificando la fecha de notificación  y entrega del permiso número $numero_permiso a su titular y el nombre y DNI de la persona que recibe la resolución en nombre de la GESTORÍA $gestoria.";

// Configurar alineación centrada y ancho del texto
$pdf->SetXY(20, 125); // Coordenadas de inicio (ajustar según sea necesario)
$pdf->MultiCell(170, 6, utf8_decode($text), 0, 'J'); // Ancho de 170, altura de línea 8, alineado centrado ('C')


$pdf->SetXY(10, 10);

// Texto centrado con MultiCell
$text = "$titulo \n $funcionario \n (firmado electrónicamente) ";

// Configurar alineación centrada y ancho del texto
$pdf->SetXY(20, 210); // Coordenadas de inicio (ajustar según sea necesario)
$pdf->MultiCell(170, 6, utf8_decode($text), 0, 'C'); // Ancho de 170, altura de línea 8, alineado centrado ('C')

ob_clean();
$pdf->Output('I', 'archivo.pdf');

?>
