<?php
session_start(); // Inicia la sesión

// Verificar si la variable de sesión 'userjpt' está definida y no está vacía
if (empty($_SESSION['userjpt'])) {
    // Si no hay datos en 'userjpt', redirige a ../auth
    header("Location: ../auth");
    exit(); // Termina el script para evitar ejecución posterior
}

// Función para escapar salidas de forma segura
function escape($value) {
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="Sistema VIGEX para canjes de permisos - DGT">
    <title>VIGEX - CANJES</title>
    <link rel="stylesheet" href="https://10.50.17.50/swap-pro/public/bootstrap.min.css">
    <link rel="icon" href="../assets/favicon.ico" type="image/x-icon">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand font-weight-bold" href="../home">
                <img src="../assets/logo-dgt.png" width="30" height="30" class="d-inline-block align-top mr-2" alt="Logo DGT">
                VIGEX - DGT
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="../home"><i class="fas fa-home"></i> Inicio</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="../arch"><i class="fas fa-folder-open"></i> Expedientes</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-cogs"></i> GESTOR
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="../envios"><i class="fas fa-paper-plane"></i> Envío Permisos</a>
                            <a class="dropdown-item" href="../estd"><i class="fas fa-chart-bar"></i> Estadística</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="../admin"><i class="fas fa-users-cog"></i> Administración</a>
                        </div>
                    </li>
                    <li class="nav-item">
                        <span class="nav-link text-light"><i class="fas fa-building"></i> JPTGI</span>
                    </li>
                </ul>
                
                <div class="navbar-text mr-3 text-light">
                    <i class="fas fa-user-circle"></i> Usuario: <?php echo escape($_SESSION['userjpt']); ?>
                    <a href="../logout" class="btn btn-sm btn-outline-light ml-2"><i class="fas fa-sign-out-alt"></i> Salir</a>
                </div>
                
                <form method="GET" action="../arch" class="form-inline my-2 my-lg-0">
                    <div class="input-group">
                        <input name="doi" type="text" class="form-control" placeholder="DOI o 1er Apellido" aria-label="Buscar" required>
                        <div class="input-group-append">
                            <button class="btn btn-light" type="submit">
                                <i class="fas fa-search"></i> Buscar
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </nav>
    
    <!-- Contenido principal irá aquí -->
    <div class="container mt-4">
        <!-- Aquí se insertará el contenido específico de cada página -->
    </div>
    
    <footer class="footer mt-auto py-3 bg-light">
        <div class="container text-center">
            <span class="text-muted">© <?php echo date('Y'); ?> Dirección General de Tráfico - VIGEX Sistema de Canjes</span>
        </div>
    </footer>
    
    <!-- Scripts -->
    <script src="https://10.50.17.50/swap-pro/public/jquery-3.5.1.slim.min.js"></script>
    <script src="https://10.50.17.50/swap-pro/public/popper.min.js"></script>
    <script src="https://10.50.17.50/swap-pro/public/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/js/all.min.js"></script>
</body>
</html>