<?php
// Configuración de la conexión a las bases de datos
try {
    // Base de datos JPTGI
    $dsn_jptgi = "mysql:host=localhost;dbname=JPTGI;charset=utf8";
    $username_jptgi = "supervisor";
    $password_jptgi = "Pinpad2021";
    $db_jptgi = new PDO($dsn_jptgi, $username_jptgi, $password_jptgi);

    // Base de datos cnj_jptgi
    $dsn_cnj_jptgi = "mysql:host=localhost;dbname=cnjs_jptgi;charset=utf8";
    $username_cnj_jptgi = "supervisor";
    $password_cnj_jptgi = "Pinpad2021";
    $db_cnj_jptgi = new PDO($dsn_cnj_jptgi, $username_cnj_jptgi, $password_cnj_jptgi);

    // Configurar PDO para que arroje excepciones en caso de errores
    $db_jptgi->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db_cnj_jptgi->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Obtener la dirección IP del cliente
$client_ip = $_SERVER['REMOTE_ADDR'];

// Intentar obtener el nombre de host del cliente a partir de su IP
$client_host = gethostbyaddr($client_ip);

// Obtén los parámetros GET
$user = isset($_GET['user']) ? $_GET['user'] : null;
$doi = isset($_GET['doi']) ? $_GET['doi'] : null;

// Verificar si el usuario está habilitado en la base de datos JPTGI
if ($user && $doi) {
    $query_user_check = "SELECT * FROM `user_permisos_mail` WHERE user = :user AND CNJ = 1";
    $stmt_user_check = $db_jptgi->prepare($query_user_check);
    $stmt_user_check->bindParam(':user', $user);
    $stmt_user_check->execute();
    $user_exists = $stmt_user_check->rowCount() > 0;

    // Si el usuario tiene permisos, ejecutar las consultas en la base de datos cnj_jptgi
    if ($user_exists) {
        try {
            // Iniciar una transacción para asegurar que todas las eliminaciones se hagan juntas
            $db_cnj_jptgi->beginTransaction();

            // Comandos DELETE en cnj_jptgi
            $delete_queries = [
                "DELETE FROM `exp_data` WHERE `DOI` = :doi",
                "DELETE FROM `reg_tram` WHERE `DOI` = :doi",
                "DELETE FROM `reg_perm` WHERE `DOI` = :doi",
                "DELETE FROM `reg_anot` WHERE `DOI` = :doi"
            ];

            foreach ($delete_queries as $query) {
                $stmt_delete = $db_cnj_jptgi->prepare($query);
                $stmt_delete->bindParam(':doi', $doi);
                $stmt_delete->execute();
            }

            // Insertar en la tabla log
            $query_log = "INSERT INTO `log` (`id`, `fecha`, `user`, `accion`, `doi`, `equipo`, `ip`) VALUES (NULL, :fecha, :user, '1', :doi, :equipo, :ip)";
            $stmt_log = $db_cnj_jptgi->prepare($query_log);

            // Preparar datos para el registro en log
            $fecha = date("Y-m-d H:i:s");
            $stmt_log->bindParam(':fecha', $fecha);
            $stmt_log->bindParam(':user', $user);
            $stmt_log->bindParam(':doi', $doi);
            $stmt_log->bindParam(':equipo', $client_host);
            $stmt_log->bindParam(':ip', $client_ip);
            $stmt_log->execute();

            // Confirmar la transacción
            $db_cnj_jptgi->commit();

            echo "Operación completada y registrada en el log con éxito.";

        } catch (PDOException $e) {
            // En caso de error, revertir la transacción
            $db_cnj_jptgi->rollBack();
            echo "Error en la operación: " . $e->getMessage();
        }
    } else {
        echo "El usuario no tiene permisos para realizar esta operación.";
    }
} else {
    echo "Faltan parámetros necesarios (user o doi).";
}
?>
