<?php
include "../../public/menu.php";
$doi = $_GET['doi'];
?>
<div class="container mt-5">
    <h5 class="mb-4">Formulario Teórico Especifíco</h5>
    <form action="insert-circ.php" method="get" class="row g-3">
        <div class="col-md-6">
            <label for="DOI" class="form-label">Documento de Identidad (DOI):</label>
            <input type="text" id="DOI" name="DOI" value="<?php echo $doi; ?>" class="form-control" readonly>
        </div>
             <!-- Campo Permisos -->
        <div class="col-md-6">
            <label for="PE" class="form-label">Permisos:</label>
            <select name="PE" id="PE" class="form-control" required>
                <option value="" disabled selected>Seleccione un permiso</option>
                <option value="A1">A1</option>
                <option value="A2">A2</option>
                <option value="AM">AM</option>
                <option value="A">A</option>
                <option value="B">B</option>
                <option value="B+E">B+E</option>
                <option value="BTP">BTP</option>
                <option value="C1">C1</option>
                <option value="C1+E">C1+E</option>
                <option value="C">C</option>
                <option value="C+E">C+E</option>
                <option value="D1">D1</option>
                <option value="D1+E">D1+E</option>
                <option value="D">D</option>
                <option value="D+E">D+E</option>
                <option value="LCC">LCC</option>
                <option value="ADR">ADR</option>
            </select>
        </div>

        <!-- Campo Fecha del Examen -->
        <div class="col-md-6">
            <label for="datex" class="form-label">Fecha Examen:</label>
            <input type="date" id="datex" name="datex" class="form-control" required>
        </div>

        <!-- Campo Hora -->
        <div class="col-md-6">
            <label for="time" class="form-label">Hora:</label>
            <input type="time" id="time" name="time" class="form-control" required>
        </div>

        <!-- Campo B96 (checkbox) -->
        <div class="col-md-6">
            <label for="b96" class="form-label">B96:</label>
            <select name="b96" id="b96" class="form-control">
                <option value="" disabled selected>Seleccione</option>
                <option value="X">X</option>
                <option value="">Vacío</option>
            </select>
        </div>

        <!-- Campo DNI o NIE (doiprofe) -->
        <div class="col-md-6">
            <label for="doiprofe" class="form-label">DNI o NIE:</label>
            <input type="text" id="doiprofe" name="doiprofe" class="form-control" pattern="([0-9]{8}[A-Za-z]{1}|[KLM]{1}[0-9]{7}[A-Za-z]{1})" required>
            <div id="doiprofeError" class="invalid-feedback">
                El DNI o NIE no es válido.
            </div>
        </div>

        <!-- Campo Matrícula -->
        <div class="col-md-6">
            <label for="matricula" class="form-label">Matrícula:</label>
            <input type="text" id="matricula" name="matricula" class="form-control" maxlength="7" required>
        </div>

        <!-- Botón Enviar -->
        <div class="col-12">
            <button type="submit" class="btn btn-primary">Enviar</button>
        </div>
    </form>
</div>

<!-- Script para validar DNI/NIE -->
<script>
    document.getElementById('doiprofe').addEventListener('input', function() {
        const doiprofe = document.getElementById('doiprofe');
        const doiprofeError = document.getElementById('doiprofeError');
        const dniPattern = /^(\d{8}[A-Za-z])|([KLM]{1}\d{7}[A-Za-z])$/;

        if (!dniPattern.test(doiprofe.value)) {
            doiprofe.classList.add('is-invalid');
            doiprofeError.style.display = 'block';
        } else {
            doiprofe.classList.remove('is-invalid');
            doiprofeError.style.display = 'none';
        }
    });
</script>