<?php
// Activar buffering para evitar errores de salida previa
ob_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('./FPDF/fpdf.php');

// Clase extendida para justificar texto
class PDF_Justify extends FPDF {
    function MultiCellJustified($w, $h, $txt) {
        $cw = &$this->CurrentFont['cw'];
        if ($w == 0)
            $w = $this->w - $this->rMargin - $this->x;
        $wmax = ($w - 2 * $this->cMargin) * 1000 / $this->FontSize;
        $s = str_replace("\r", '', $txt);
        $nb = strlen($s);
        if ($nb > 0 && $s[$nb - 1] == "\n")
            $nb--;
        $sep = -1;
        $i = 0;
        $j = 0;
        $l = 0;
        $ns = 0;
        $nl = 1;
        while ($i < $nb) {
            $c = $s[$i];
            if ($c == "\n") {
                $this->Cell($w, $h, substr($s, $j, $i - $j), 0, 2, 'J');
                $i++;
                $sep = -1;
                $j = $i;
                $l = 0;
                $ns = 0;
                $nl++;
                continue;
            }
            if ($c == ' ') {
                $sep = $i;
                $ls = $l;
                $ns++;
            }
            $l += $cw[$c];
            if ($l > $wmax) {
                if ($sep == -1) {
                    if ($i == $j)
                        $i++;
                    $this->Cell($w, $h, substr($s, $j, $i - $j), 0, 2, 'J');
                } else {
                    $this->Cell($w, $h, substr($s, $j, $sep - $j), 0, 2, 'J');
                    $i = $sep + 1;
                }
                $sep = -1;
                $j = $i;
                $l = 0;
                $ns = 0;
                $nl++;
            } else {
                $i++;
            }
        }
        if ($i != $j)
            $this->Cell($w, $h, substr($s, $j, $i - $j), 0, 2, 'J');
    }
}

// Validación del DOI
$doi = $_GET['doi'] ?? '';
if (empty($doi) || !preg_match('/^[A-Za-z0-9\-]+$/', $doi)) {
    die("DOI inválido.");
}

// Conexión única
$mysqli = new mysqli("localhost", "supervisor", "Pinpad2021", "cnjs_jptgi");
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}
$mysqli->set_charset("utf8");

// Datos personales
$stmt = $mysqli->prepare("SELECT nombre, apellido_1, apellido_2 FROM exp_data WHERE doi = ?");
if (!$stmt) die("Error en prepare: " . $mysqli->error);
$stmt->bind_param("s", $doi);
$stmt->execute();
$stmt->bind_result($nombre, $apellido1, $apellido2);
if (!$stmt->fetch() || empty($nombre)) {
    die("No se encontraron datos para el DOI especificado.");
}
$stmt->close();

// País
$stmt = $mysqli->prepare("SELECT pais FROM reg_perm WHERE doi = ?");
if (!$stmt) die("Error en prepare: " . $mysqli->error);
$stmt->bind_param("s", $doi);
$stmt->execute();
$stmt->bind_result($pais);
$stmt->fetch();
$stmt->close();

// Fecha del trámite
$stmt = $mysqli->prepare("SELECT fecha FROM reg_tram WHERE doi = ? AND tramite like '%SOLICITUD'");
if (!$stmt) die("Error en prepare: " . $mysqli->error);
$stmt->bind_param("s", $doi);
$stmt->execute();
$stmt->bind_result($FECHA_CREACION);
if (!$stmt->fetch() || empty($FECHA_CREACION)) {
    die("No se encontró la fecha de creación del trámite.");
}
$stmt->close();
$mysqli->close();

// Convertir fecha
$FECHA_CREACION = date("d-m-Y", strtotime($FECHA_CREACION));
$url_dgt = "https://sede.dgt.gob.es/es/otros-tramites/autorizaciones-de-representaciones-rea";

// Crear PDF
$pdf = new PDF_Justify();
$pdf->AddFont('Calibri', '', 'Calibri.php');
$pdf->AddFont('Calibri', 'B', 'calibrib.php');

$pdf->AddPage();
if (!file_exists('fondo.png')) {
    die("Imagen de fondo no encontrada.");
}
$pdf->Image('fondo.png', 0, 0, 210, 297);

$pdf->SetMargins(20, 20, 20);
$pdf->SetFont('Calibri', '', 11);
$pdf->SetTextColor(0, 0, 0);

$pdf->SetXY(20, 60);
$pdf->Cell(0, 8, utf8_decode("Att. D./Dª: $nombre $apellido1 $apellido2"), 0, 1);
$pdf->SetX(20);
$pdf->Cell(0, 8, utf8_decode("DOI: $doi"), 0, 1);

$pdf->SetXY(20, 80);
$texto1 = "
Vista su solicitud, que ha tenido entrada en el Registro de la Jefatura Provincial de Tráfico de Girona en fecha $FECHA_CREACION, le comunicamos que se ha iniciado el procedimiento de canje de su permiso de conducir de $pais.

Para ultimar dicho trámite, deberá comparecer personalmente en esta Jefatura Provincial de Tráfico, ubicada en Gran Vía Jaume I, 41 2ª planta en el siguiente horario: de lunes a viernes de 11:30 a 13:30 horas, aportando la siguiente documentación:
 - Documento oficial de identidad español original, válido y en vigor.
 - Permiso de conducir original de $pais.

En el caso de que no pueda acudir personalmente, podrá autorizar a otra persona para ultimar dicho trámite en su nombre, de manera fácil y gratuita a través del Registro de Apoderamientos de la DGT:";

$pdf->MultiCellJustified(170, 6.5, utf8_decode($texto1));
$pdf->SetFont('Calibri', '', 11);
$pdf->SetTextColor(0, 0, 255);
$pdf->SetFont('', 'U');
$pdf->Write(6.5, utf8_decode(" $url_dgt"), $url_dgt);
$pdf->Ln(8);
$pdf->SetFont('', '');
$pdf->SetTextColor(0, 0, 0);

$pdf->SetFont('Calibri', 'B', 11);
$pdf->MultiCell(170, 6.5, utf8_decode("IMPORTANTE: No será necesaria la solicitud de cita previa, pero sólo se le atenderá en el horario anteriormente indicado."));
$pdf->MultiCell(170, 6.5, utf8_decode("Es necesario que aporte copia de esta comunicación para acreditar su comparecencia."));

// Frase app miDGT - Español
$pdf->Ln(5);
$pdf->SetFont('Calibri', '', 11);
$pdf->MultiCell(170, 6.5, utf8_decode("Descubre la nueva app miDGT: tu permiso de conducir y gestiones de tráfico, ahora en tu móvil. Gratuita en App Store y Google Play."));
$pdf->SetTextColor(0, 0, 255);
$pdf->SetFont('', 'U');
$pdf->Write(6.5, utf8_decode(" https://sede.dgt.gob.es/es/appmidgt/index.html"), "https://sede.dgt.gob.es/es/appmidgt/index.html");
$pdf->SetTextColor(0, 0, 0);


// Página en catalán
$pdf->AddPage();
$pdf->Image('fondo.png', 0, 0, 210, 297);

$pdf->SetFont('Calibri', '', 11);
$pdf->SetXY(20, 60);
$pdf->Cell(0, 8, utf8_decode("At. Sr./Sra.: $nombre $apellido1 $apellido2"), 0, 1);
$pdf->SetX(20);
$pdf->Cell(0, 8, utf8_decode("DOI: $doi"), 0, 1);

$pdf->SetXY(20, 80);
$texto2 = "
Vista la seva sol·licitud, que ha tingut entrada al Registre de la Prefectura Provincial de Trànsit de Girona en data $FECHA_CREACION, li comuniquem que s'ha iniciat el procediment de bescanvi del seu permís de conduir de $pais.

Per finalitzar aquest tràmit, haurà de comparèixer personalment en aquesta Prefectura Provincial de Trànsit, ubicada a Gran Via Jaume I, 41 2a planta, en l'horari següent: de dilluns a divendres, de 11:30 a 13:30 hores, aportant la següent documentació:
 - Document oficial d'identitat espanyol original, vàlid i vigent.
 - Permís de conduir original de $pais.

En cas que no pugui acudir personalment, podrà autoritzar una altra persona per finalitzar el tràmit en el seu nom, de manera fàcil i gratuïta a través del Registre d'Apoderaments de la DGT:";

$pdf->MultiCellJustified(170, 6.5, utf8_decode($texto2));
$pdf->SetFont('Calibri', '', 11);
$pdf->SetTextColor(0, 0, 255);
$pdf->SetFont('', 'U');
$pdf->Write(6.5, utf8_decode(" $url_dgt"), $url_dgt);
$pdf->Ln(8);
$pdf->SetFont('', '');
$pdf->SetTextColor(0, 0, 0);

$pdf->SetFont('Calibri', 'B', 11);
$pdf->MultiCell(170, 6.5, utf8_decode("IMPORTANT: No caldrà sol·licitar cita prèvia, però només se l'atendrà en l'horari anteriorment indicat."));
$pdf->MultiCell(170, 6.5, utf8_decode("És necessari que aporti una còpia d’aquesta comunicació per acreditar la seva compareixença."));

// Frase app miDGT - Català
$pdf->Ln(5);
$pdf->SetFont('Calibri', 'B', 11);
$pdf->MultiCell(170, 6.5, utf8_decode("Descobreix la nova app miDGT: el teu permís de conduir i tràmits de trànsit, ara al teu mòbil. Gratuïta a l'App Store i Google Play."));
$pdf->SetTextColor(0, 0, 255);
$pdf->SetFont('', 'U');
$pdf->Write(6.5, utf8_decode(" https://sede.dgt.gob.es/es/appmidgt/index.html"), "https://sede.dgt.gob.es/es/appmidgt/index.html");
$pdf->SetTextColor(0, 0, 0);


// Limpiar cualquier salida antes de generar el PDF
ob_end_clean();
$pdf->Output("D", "Comunicacion_{$nombre}_{$apellido1}_{$apellido2}_{$doi}.pdf");
?>
